/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power.factory.condition;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.power.factory.condition.ConditionFactory;
import io.github.apace100.origins.registry.ModRegistriesArchitectury;
import io.github.apace100.origins.util.Comparison;
import io.github.apace100.origins.util.SerializableData;
import io.github.apace100.origins.util.SerializableDataType;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.TieredItem;
import net.minecraft.item.crafting.Ingredient;

public class ItemConditions {
    public static void register() {
        ItemConditions.register(new ConditionFactory<ItemStack>(Origins.identifier("constant"), new SerializableData().add("value", SerializableDataType.BOOLEAN), (data, stack) -> data.getBoolean("value")));
        ItemConditions.register(new ConditionFactory<ItemStack>(Origins.identifier("and"), new SerializableData().add("conditions", SerializableDataType.ITEM_CONDITIONS), (data, stack) -> ((List)data.get("conditions")).stream().allMatch(condition -> condition.test(stack))));
        ItemConditions.register(new ConditionFactory<ItemStack>(Origins.identifier("or"), new SerializableData().add("conditions", SerializableDataType.ITEM_CONDITIONS), (data, stack) -> ((List)data.get("conditions")).stream().anyMatch(condition -> condition.test(stack))));
        ItemConditions.register(new ConditionFactory<ItemStack>(Origins.identifier("food"), new SerializableData(), (data, stack) -> stack.func_222117_E()));
        ItemConditions.register(new ConditionFactory<ItemStack>(Origins.identifier("ingredient"), new SerializableData().add("ingredient", SerializableDataType.INGREDIENT), (data, stack) -> ((Ingredient)data.get("ingredient")).test(stack)));
        ItemConditions.register(new ConditionFactory<ItemStack>(Origins.identifier("armor_value"), new SerializableData().add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.INT), (data, stack) -> {
            int armor = 0;
            if (stack.func_77973_b() instanceof ArmorItem) {
                ArmorItem item = (ArmorItem)stack.func_77973_b();
                armor = item.func_200881_e();
            }
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(armor, data.getInt("compare_to"));
        }));
        ItemConditions.register(new ConditionFactory<ItemStack>(Origins.identifier("harvest_level"), new SerializableData().add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.INT), (data, stack) -> {
            int harvestLevel = 0;
            if (stack.func_77973_b() instanceof TieredItem) {
                TieredItem item = (TieredItem)stack.func_77973_b();
                harvestLevel = item.func_200891_e().func_200925_d();
            }
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(harvestLevel, data.getInt("compare_to"));
        }));
        ItemConditions.register(new ConditionFactory<ItemStack>(Origins.identifier("enchantment"), new SerializableData().add("enchantment", SerializableDataType.ENCHANTMENT).add("compare_to", SerializableDataType.INT).add("comparison", SerializableDataType.COMPARISON), (data, stack) -> {
            int enchantLevel = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)data.get("enchantment")), (ItemStack)stack);
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(enchantLevel, data.getInt("compare_to"));
        }));
        ItemConditions.register(new ConditionFactory<ItemStack>(Origins.identifier("meat"), new SerializableData(), (data, stack) -> stack.func_222117_E() && stack.func_77973_b().func_219967_s().func_221467_c()));
    }

    private static void register(ConditionFactory<ItemStack> conditionFactory) {
        ModRegistriesArchitectury.ITEM_CONDITION.register(conditionFactory.getSerializerId(), () -> conditionFactory);
    }
}

